//
//  WXKLightMail.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/28.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "WXKLightMail.h"


@interface WXKLightMail (Private)

- (void)setTransientValue;

@end


#pragma mark -


@implementation WXKLightMail

- (void)awakeFromFetch
{
	[super awakeFromFetch];
	
	[self setTransientValue];
}

- (NSData *)message
{
	NSData *tempObject;
	
    [self willAccessValueForKey:@"message"];
    tempObject = [self primitiveValueForKey:@"message"];
    [self didAccessValueForKey:@"message"];
	
    return tempObject;
}

- (void)setMessage:(NSData *)value
{
	[self willChangeValueForKey:@"message"];
	[self setPrimitiveValue: value forKey:@"message"];
	[self didChangeValueForKey:@"message"];
	
	[self setTransientValue];
}

- (NSString *)from
{
	if ([[self valueForKeyPath:@"folder.order"] intValue] == 3) {
		return [self valueForKey:@"object"];
	}
	return nil;
}

- (NSString *)to
{
	if ([[self valueForKeyPath:@"folder.order"] intValue] == 1 || // mailbox is sent or drafts
		[[self valueForKeyPath:@"folder.order"] intValue] == 2) {
		return [self valueForKey:@"object"];
	}
	return nil;
}

@end


#pragma mark -


@implementation WXKLightMail (Private)

- (void)setTransientValue
{
	NSData *data = [self valueForKey:@"message"];
	if (data) {
		NSString *string = [[[NSString alloc] initWithData:data encoding:NSShiftJISStringEncoding] autorelease];
		[self setValue:string forKey:@"subject"];
		[self setValue:string forKey:@"body"];
	}
}

@end
